
var nt_autosave_running = false;

function ldnt_start_autosave() {

    setTimeout(function() {
        if( nt_autosave_running == true ) {
            jQuery('.nt-note-submit').click();
            ldnt_start_autosave();
        }
    }, 30000 );

}

function nt_save_coordinates( ui ) {

    data = {};

    if( ui.size ) {
        data.width          = ui.size.width;
        data.height         = ui.size.height;
        data.tinymce_height = jQuery('#nt-note-body_ifr').height();
    }

    if( ui.position ) {
        data.position_top  = ui.position.top;
        data.position_left = ui.position.left;
    }

    jQuery.ajax({
        url     : nt_ajax_call.adminAjax + '?action=nt_note_save_coordinates',
        type    : 'post',
        data    : data,
        success: function( data ) {
        }
    });

}

function nt_update_size( ui ) {

     var height = jQuery( ui.element ).find('.nt-note-editor-body').height();
     var barHeight = jQuery( ui.element ).find('.mce-top-part').height();
     var netHeight = height - barHeight;

     jQuery( ui.element ).find('iframe').height(netHeight);

     return;
}

jQuery.expr.filters.offscreen = function(el) {
  var rect = el.getBoundingClientRect();
  return (
           (rect.x + rect.width) < 0 || (rect.y + rect.height) < 0 || (rect.x > window.innerWidth || rect.y > window.innerHeight)
         );
};

function nt_check_if_outside_window() {

    if( jQuery('.nt-note-wrapper').is(':offscreen') ) {

        jQuery( '.nt-note-wrapper' ).css({
            left        : 'auto',
            right       : '15px',
            top         : '30%',
            width       : 'auto',
            height      :   'auto'
        }).removeClass( 'nt-resized' );

        jQuery( '#nt-note-body_ifr' ).css( 'height', 'auto' );

        nt_reset_coordinates();
    }

}

function nt_reset_coordinates() {

    data = {
        width           : 'reset',
        height          : 'reset',
        position_top    : 'reset',
        position_left   : 'reset',
        tinymce_height  : 'reset'
    };

    jQuery.ajax({
        url     : nt_ajax_call.adminAjax + '?action=nt_note_save_coordinates',
        type    : 'post',
        data    : data,
        success: function( data ) {


        }
    });

}

jQuery(function($) {



    if( $( '.nt-note-wrapper' ).length ) {

        if( !$('.nt-note-wrapper').parents('.ldnt-in-content-notes').length ) {
            wrapper = $('.nt-note-wrapper').detach();
            $('body').prepend(wrapper);
        }

        $( ".nt-note-wrapper" ).draggable({
            start: function( e, ui ) {
                $( this ).addClass( 'nt-dragged' );
            },
            snapMode: "inner",
            containment: "window",
            stop: function( e, ui ) {
                nt_save_coordinates( ui );
            }
        }).resizable({

            start: function( e, ui ) {
                $( this ).addClass( 'nt-resized' );
            },
            alsoResize: '#nt-note-body_ifr',
            minWidth: 300,
            minHeight: 350,
            stop: function( e, ui ) {
                nt_save_coordinates( ui );
                nt_update_size( ui );
            }

        });

        $(document).on('mouseup',function(){
            $(".nt-note-wrapper").trigger('resizestop');
        });

    }

  });

jQuery(document).ready( function($) {

    nt_set_initial_positions();

    function nt_set_initial_positions() {

        if( nt_ajax_call.nt_position_top ) {
            $('.nt-note-wrapper').css( 'top', nt_ajax_call.nt_position_top + 'px' );
        }

        if( nt_ajax_call.nt_position_left ) {
            $('.nt-note-wrapper').css( 'left', nt_ajax_call.nt_position_left + 'px' );
        }

        if( nt_ajax_call.nt_width ) {
            $('.nt-note-wrapper').css( 'width', nt_ajax_call.nt_width + 'px' ).addClass( 'nt-resized' ).addClass( 'nt-resized-at-init' );
        }

        if( nt_ajax_call.nt_tinymce_height && $(window).width() > 768 ) {
            $('#nt-note-body_ifr').height( nt_ajax_call.nt_tinymce_height );
        }

        if( $(window).width() < 768 ) {
            $('#nt-note-body_ifr').height( 50 );
        }

    }

    $('body').on( 'click', '.js-toggle-all-notes', function(e) {

         var parent = $(this).parents('.notes-listing');

         if( $(this).prop('checked') ) {

              $(parent).find('.nl-select input[type="checkbox"]').prop( 'checked', true );

         } else {

              $(parent).find('.nl-select input[type="checkbox"]').prop( 'checked', false );

         }

    });

    $('body').on( 'submit', '.ldnt-note-listing-form', function(e) {

        var submitType = $(this).find('.lds-bulk-actions').val();

        if( submitType == 'delete' ) {
             if( confirm( nt_ajax_call.nt_delete_txt ) == false ) {
                  e.preventDefault();
             }
        }

    });

    /*
    if( typeof tinyMCE !== 'undefined' ) {
         tinymce.on('AddEditor', function (inst) {
             inst.editor.on('init', function () {
                 inst.editor.execCommand('wpAutoResizeOn');
             });
         });
    } */

    $('body').on( 'click touchstart', '.learndash-notes-print-modal', function(e) {

        e.preventDefault();

        var parent = $(this).parents('form');

        if( typeof tinyMCE !== 'undefined' ) {

             var target  = $(parent).data('bodyid');
             var ed      = tinyMCE.get(target);
             content     = ed.getContent();

        } else {
            content = $(parent).find('.wp-editor-area').val();
        }

        title   = $(parent).find('.nt-note-title').val();

        if( !$('#nt-print-wrapper' ).length ) {
            var print_markup    = '<div id="nt-print-wrapper" class="nt-hide"><h1>' + title + '</h1>' + content + '</div>';
            $(this).parent().append( print_markup );
        } else {
            $('#nt-print-wrapper').html( content );
        }

        $('#nt-print-wrapper').ld_print();

    });

    $('body').on( 'click touchstart', '.learndash-notes-download-modal', function(e) {

        e.preventDefault();

        var parent = $(this).parents('form');

        if( typeof tinyMCE !== 'undefined' ) {
             var target  = $(parent).data('bodyid');
             var ed      = tinyMCE.get(target);
             content     = ed.getContent();
        } else {
            content = $(parent).find('.wp-editor-area').val();
        }

        var formData = {
             'title'             : $(parent).find('.nt-note-title').val(),
             'body'              : content,
             'userId'            : $(parent).find('.nt-note-user-id').val(),
             'currentLessonId'   : $(parent).find('.nt-note-current-lessson-id').val(),
             'currentPostType'   : $(parent).find('.nt-note-current-post-type').val(),
             'noteId'            : $(parent).find('.nt-note-id').val(),
             'parent'            : $(parent).attr('id')
        };

        nt_adminAjaxRequest( formData, 'nt_process_course_note', true );

    });

    var dt   = new Date();
    var time = dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();

    var nt_adminAjaxRequest = function( formData, action, download = false ) {

        var parent = $( '#' + formData.parent );

        var dt   = new Date();
        var time = dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();
        var oldLabel = $(parent).find( '.nt-note-submit' ).val();

        $(parent).find( '.nt-note-submit' ).attr( 'disabled', true ).addClass( 'nt-note-saving' );

        jQuery.ajax({
          type: 'POST',
          url: nt_ajax_call.adminAjax,
          data: {
            action: action,
            data: formData,
            submission: document.getElementById('xyz').value,
            security: nt_ajax_call.security
          },
          success: function( response ) {

              $(parent).find( '.nt-note-submit' ).val( nt_ajax_call.nt_saved_at_txt + ' ' + time ).prop( 'disabled', false );

              if( download == true ) {

                  var sep = '';

                  if( nt_ajax_call.nt_permalinks == 'yes' ) {
                      sep = '?';
                  } else {
                      sep = '&';
                  }

                  window.location.assign( response['data']['data'] + sep + 'nt_download_doc=true' );

              }

              if( $(parent).find('.nt-note-id').val() == 'new' ) {
                  $(parent).find('.nt-note-id').val(response['data']['post_id']);
              }

              setTimeout(function() {

                  $(parent).find( '.nt-note-submit' ).val( oldLabel ).removeClass( 'nt-note-saving' );

              }, 4000);

            }

        });
  };

  $('body').on( 'click touchstart', '.nt-note-submit', function(e) {

       e.preventDefault();

       var parent = $(this).parents('form');

       if( typeof tinyMCE !== 'undefined' ) {

            var target  = $(parent).data('bodyid');
            var ed      = tinyMCE.get(target);
            content     = ed.getContent();

       } else {

          if( $(parent).find('.wp-editor-area').length ) {
               content = $(parent).find('.wp-editor-area').val();
          } else {
               alert('Something went wrong, we couldn\'t find a note pad on the page.');
          }

       }

      var formData = {
            'title'             : $(parent).find('.nt-note-title').val(),
            'body'              : content,
            'userId'            : $(parent).find('.nt-note-user-id').val(),
            'currentLessonId'   : $(parent).find('.nt-note-current-lessson-id').val(),
            'currentPostType'   : $(parent).find('.nt-note-current-post-type').val(),
            'noteId'            : $(parent).find('.nt-note-id').val(),
            'parent'            : $(parent).attr('id')
        };

        nt_adminAjaxRequest( formData, 'nt_process_course_note' );

  });

  $('body').on( 'click touchstart', '.nt-note-trigger', function(e) {

     e.preventDefault();

     $( '.nt-note-wrapper' ).css( 'display', 'flex').fadeIn( 'slow' ).addClass( 'active' );

     nt_check_if_outside_window();

     if( (nt_ajax_call.nt_tinymce_height ) && ( $( '.nt-note-wrapper' ).hasClass( 'nt-resized-at-init') ) ) {
          $( '#nt-note-body_ifr' ).css( 'height', nt_ajax_call.nt_tinymce_height + 'px' );
     }

     if( typeof(tinymce) !== 'undefined' ) {

          var tinyTarget = $('#nt-course-note').data('bodyid');
          tinymce.init( tinyMCEPreInit.mceInit[tinyTarget] );

     }

     if( nt_ajax_call.nt_autosave == 'yes' ) {

          nt_autosave_running = true;

          ldnt_start_autosave();

     }

     if( $(window).width() < 768 ) {

          var containerHeight = $('.nt-note-wrapper').height();
          var elementHeights = $('#nt-note-title-field').height() + $('#nt-note-actions').height() + $('#nt-utility-links').height() + $('.note-body .mce-toolbar-grp').height();

          var editorHeight = containerHeight - 53 - elementHeights;

     $('#nt-note-body_ifr').height(editorHeight);

     }

  });

  $('body').on( 'click touchstart', '.nt-note-tab', function(e) {

      e.preventDefault();

      $(this).fadeOut('slow');

      $( '.nt-note-wrapper' ).css( 'display', 'flex').fadeIn( 'slow' ).addClass( 'active' );

      nt_check_if_outside_window();

      if( (nt_ajax_call.nt_tinymce_height ) && ( $( '.nt-note-wrapper' ).hasClass( 'nt-resized-at-init') ) ) {
          $( '#nt-note-body_ifr' ).css( 'height', nt_ajax_call.nt_tinymce_height + 'px' );
      }

      if( typeof(tinymce) !== 'undefined' ) {
           var tinyTarget = 'nt-note-body-' + $(this).data('contentid');
           tinymce.init( tinyMCEPreInit.mceInit[tinyTarget] );
      }

      if( nt_ajax_call.nt_autosave == 'yes' ) {

          nt_autosave_running = true;

          ldnt_start_autosave();

      }

      if( $(window).width() < 768 ) {

          var containerHeight = $('.nt-note-wrapper').height();
          var elementHeights = $('#nt-note-title-field').height() + $('#nt-note-actions').height() + $('#nt-utility-links').height() + $('.note-body .mce-toolbar-grp').height();

          var editorHeight = containerHeight - 53 - elementHeights;

          $('#nt-note-body_ifr').height(editorHeight);

      }

  });

  $('body').on( 'click touchstart', '.nt-reset-dimensions', function(e) {

      e.preventDefault();

      $( '.nt-note-wrapper' ).css({
          left        : 'auto',
          right       : '15px',
          top         : '30%',
          width       : 'auto',
          height      :   'auto'
      }).removeClass( 'nt-resized' );

      $( '#wp-nt-note-body-wrap' ).css( 'height', 'auto' );

      nt_reset_coordinates();

  });

  $('body').on('touchstart', '.note-body a[href^="http"]', function(e) {
          var url = $(this).attr('href');
          window.location = url;
  });

  $('body').on( 'click touchstart', '.nt-close-icon', function(e) {

      e.preventDefault();

      $( '.nt-note-wrapper' ).removeClass( 'active' ).fadeOut( 'slow', function() {

          $( '.nt-note-tab' ).fadeIn( 'slow' );
          $( '#nt_note_cont' ).removeClass( 'z-index' );
          $( '.ldnt-content-notes' ).removeClass( 'z-index' );

          nt_autosave_running = false;

      });

  });

  $('body').on( 'click touchstart', '.learndash-notes-delete-note', function(e) {

        e.preventDefault();

        var r = confirm( nt_ajax_call.nt_delete_txt );

        if ( r == true ) {

            var note_id = $(this).data( 'note' );
            var element = $(this);

            jQuery.ajax({
                url     : nt_ajax_call.adminAjax + '?action=nt_delete_note',
                type    : 'post',
                data    : {
                    note_id : note_id
                },
                success: function( data ) {

                    $( element ).parents( 'tr' ).fadeOut( 'slow' );

                }

            });

        }

    });

});
