jQuery(document).ready(function ($) {

	'use strict';

	/*
	References
	http://codeblow.com/questions/method-to-check-whether-tinymce-is-active-in-wordpress/
	https://wordpress.org/support/topic/tinymceactiveeditorgetcontentcontent-does-not-work-with-tinymce-advanced
	 */

	var linkToFAQ,
		reply = $('#wpas_reply'),
		replyWrap = $('#wp-wpas_reply-wrap'),
                select = $('.asfaq_quick_reply_select'),
                createFAQ = $('.wpas_toolbar_item_asfaq_create_faq');

	select.on('change', function (e) {
		e.preventDefault();
                
                if( $(this).hasClass('disabled') || !$(this).val() ) {
                        return;
                }

                var dd = $(this);

                dd.addClass( 'disabled' );

                var loader = $('<span class="spinner"></span>');
                loader.css({visibility: 'visible', float : 'none' });
                
                $('.asfaq_quick_reply_wrapper').append(loader);


                var data = {
                        action    : 'wpas_faq_get_faq_link_content',
                        ticket_id : wpas.ticket_id,
                        faq_id    : dd.val(),
                        security  : $('#wpas_faq_get_faq_link_content_nonce').val()
                };

                $.post( ajaxurl, data, function (response) {
                        
                        loader.remove();
                        dd.removeClass( 'disabled' );
                        
                        if( !response.success ) {
                                return;
                        }
                        
                        linkToFAQ = response.data.content;
                        
                        
                        /* Check if faq item/response is empty */
                        if( !linkToFAQ || !linkToFAQ.trim() ) {
                                alert('This FAQ response is empty.');
                                return;
                        }
                        
                        /* Check which editor is active TinyMCE or HTML */
                        if (replyWrap.hasClass('tmce-active')) {

                                /* Check if TinyMCE is loaded */
                                if (typeof (tinyMCE) != 'undefined') {

                                        /* Check version of TinyMCE */
                                        if (tinymce.majorVersion < 4) {
                                                tinyMCE.execInstanceCommand('wpas_reply', 'mceInsertContent', false, linkToFAQ);
                                        } else {
                                                tinyMCE.get('wpas_reply').insertContent(linkToFAQ);
                                        }

                                }

                        } else {

                                /* Append canned response to existing textarea value */
                                reply.val(function (i, val) {
                                        return val + linkToFAQ;
                                });

                        }

                        // Activate Reply form tab
                        if( linkToFAQ.trim() ) {
                                $('#wpas_admin_tabs_after_reply_wysiwyg li[rel=wpas_admin_tabs_after_reply_wysiwyg_reply_form]').trigger('click');
                        }

                        
                        
                });
                
        });
        
        createFAQ.click(function (event) {
            if ($(this).hasClass("disabled")) {
                event.preventDefault();
            }
            $(this).addClass("disabled");
        });

});
