<?php
/**
 * PHPUnit bootstrap file.
 *
 * @package Learndash_Course_Grid
 */

if ( PHP_MAJOR_VERSION >= 8 ) {
	echo "The scaffolded tests cannot currently be run on PHP 8.0+. See https://github.com/wp-cli/scaffold-command/issues/285" . PHP_EOL; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	exit( 1 );
}

$_tests_dir = getenv( 'WP_TESTS_DIR' );

if ( ! $_tests_dir ) {
	$_tests_dir = rtrim( sys_get_temp_dir(), '/\\' ) . '/wordpress-tests-lib';
}

if ( ! file_exists( "{$_tests_dir}/includes/functions.php" ) ) {
	echo "Could not find {$_tests_dir}/includes/functions.php, have you run bin/install-wp-tests.sh ?" . PHP_EOL; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	exit( 1 );
}

// Set globals
$active_plugins = [
	'learndash-course-grid/learndash-course-grid.php',
	'sfwd-lms/sfwd_lms.php',
];

$GLOBALS['wp_tests_options'] = [
	'active_plugins' => $active_plugins
];

// Give access to tests_add_filter() function.
require_once "{$_tests_dir}/includes/functions.php";

/**
 * Manually load the plugin being tested.
 */
function _manually_load_plugin() {
	require dirname( dirname( __FILE__ ) ) . '/learndash_course_grid.php';

	define( 'LEARNDASH_LMS_PLUGIN_DIR', dirname( dirname( dirname( __FILE__ ) ) ) . '/sfwd-lms/' );
	define( 'LEARNDASH_FILE', dirname( dirname( dirname( __FILE__ ) ) ) . '/sfwd-lms/sfwd_lms.php' );
	require dirname( dirname( dirname( __FILE__ ) ) ) . '/sfwd-lms/sfwd_lms.php';
}

tests_add_filter( 'muplugins_loaded', '_manually_load_plugin' );

// Start up the WP testing environment.
require "{$_tests_dir}/includes/bootstrap.php";
